unit Faxdemo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Ver, ddeman, FileCtrl, Printers,
  Spin, ExtCtrls;

type
  TForm1 = class(TForm)
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Button1: TButton;
    Button2: TButton;
    DdeClientConv1: TDdeClientConv;
    Label7: TLabel;
    Label8: TLabel;
    ListBox2: TListBox;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    RadioGroup1: TRadioGroup;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    Edit1: TEdit;
    CheckBox2: TCheckBox;
    Edit2: TEdit;
    CheckBox3: TCheckBox;
    Timer1: TTimer;
    ListBox1: TListBox;
    CheckBox4: TCheckBox;
    Panel1: TPanel;
    Label9: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    SpinButton1: TSpinButton;
    Label11: TLabel;
    ListBox3: TListBox;
    Label10: TLabel;
    Label12: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label13: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Edit2Click(Sender: TObject);
    procedure Edit5Click(Sender: TObject);
    procedure Edit6Click(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  i : integer;
  WinFaxAvailable,
  MSAWFaxAvailable : boolean;

implementation

{$R *.DFM}

uses faxlib;

function PadLwith(s:string;i:integer;c:char):string;
begin
  while length(s)<i do s:=c+s;
  PadLwith := s;
end;

procedure TForm1.FormCreate(Sender: TObject);
var s : string;
begin
  WinFaxAvailable := bWinFaxInstalled;
  MSAWFaxAvailable := bMSAWFaxInstalled;

  if WinFaxAvailable then begin
    Label3.Caption := 'WinFax directory ' + sGetWinFaxDir;
    Label4.Caption := 'WinFax is available';
  end
  else begin
    Label3.Caption := '';
    Label4.Caption := 'WinFax is not available';
  end;

  if MSAWFaxAvailable then
    Label5.Caption := 'Microsoft At Work PC Fax is available'
  else
    Label5.Caption := 'Microsoft At Work PC Fax is not available';

  S := FormatDateTime('mm/dd/yy hh:mm', Now);
  Label9.Caption := copy(S,1,8);
  Edit5.Text := copy(S,10,2);                     { add 2 minutes }
  Edit6.Text := PadLwith(IntToStr(StrToInt(copy(S,13,2))+2),2,'0');

  ListBox1.Clear;
  ListBox1.Items.Add('This is a sample of the basic text of the fax.');
  ListBox1.Items.Add('');
  ListBox1.Items.Add('This could also be populated using LoadFromFile,');
  ListBox1.Items.Add('or the text could be printed directly to the printer.');

  ListBox2.Clear;
  ListBox2.Items.Add('Hello, this is a sample of text for a cover page.');
  ListBox2.Items.Add('');
  ListBox2.Items.Add('This could also be populated using LoadFromFile.');

  Label8.Caption := '';

  if WinFaxAvailable then RadioGroup1.ItemIndex := 0;
  if MSAWFaxAvailable then RadioGroup1.ItemIndex := 1;
  if RadioGroup1.ItemIndex < 0 then
    Button2.Enabled := false
  else
    Button2.Enabled := true;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  MyFile: TextFile;
  ii: integer;
  tBuffer : TStringList;
begin
  Screen.Cursor := crHourGlass;
  if RadioGroup1.ItemIndex = 0 then begin
    { turns on DDE conversation...starts WinFax Pro if it is not already }
    bEstablishWinFaxLink(DdeClientConv1);
    if WinFaxLinkOK then begin
       bSelectWinFaxAsPrinter;
       bSetWinFaxIdle;
       if CheckBox4.Checked then
         bSetSendFaxDialogScreenON
       else begin
         bSetSendFaxDialogScreenOFF;
         bSetRecipientInfo(Edit3.Text,
                           PadLwith(Edit5.Text,2,'0')+':'+
                             PadLwith(Edit6.Text,2,'0')+':00',
                           Label9.Caption,
                           'Customer Service Rep.',
                           Edit4.Text,
                           'Test Fax',
                           '',
                           '');
       end;
       if CheckBox3.Checked then
         bSetWinFaxResolutionHIGH
       else
         bSetWinFaxResolutionLOW;
       if CheckBox2.Checked and FileExists(Edit2.Text) then
         bSetAttachFile(Edit2.Text);
       if CheckBox1.Checked then begin
         if FileExists(Edit1.Text) then
           bSetCoverPage(Edit1.Text)
         else
           bSetCoverPage(''); { selects the "quick" cover page }
         ListBox3.Items := ListBox2.Items; { do this because it will be altered }
         bFillCoverPage( ListBox3 );
       end;

       Printer.Canvas.Font.Color := clBlack;
       Printer.Canvas.Font.Name  := 'Courier';
       Printer.Canvas.Font.Size  := 24;
       Printer.Canvas.Font.Style := [];
     { Printer.Orientation := poPortrait;}{ Orientation not supported by WinFax }
       AssignPrn(MyFile);
       Rewrite(MyFile);

     { print something }
       for ii:= 0 to (ListBox1.Items.Count - 1) do
         Writeln(MyFile, ListBox1.Items[ii]);

     { close the printer }
       System.CloseFile(MyFile);
       if Printer.Printing then
         Printer.EndDoc; { just in case }

     { bSetWinFaxSendFaxUI; }
       bSetWinFaxActive;
       bDeselectWinFaxAsPrinter;  { also deselects MS At Work PC Fax }
       bBreakWinFaxLink;
    end;
  end
  else
  if RadioGroup1.ItemIndex = 1 then begin
     bSelectMSAWFaxAsPrinter;

     Printer.Canvas.Font.Color := clBlack;
     Printer.Canvas.Font.Name  := 'Courier';
     Printer.Canvas.Font.Size  := 24;
     Printer.Canvas.Font.Style := [];
{    Printer.Orientation := poPortrait;}{ Orientation not supported }
     AssignPrn(MyFile);
     Rewrite(MyFile);

   { print something }
     for ii:= 0 to (ListBox1.Items.Count - 1) do
       Writeln(MyFile, ListBox1.Items[ii]);

   { close the printer }
     System.CloseFile(MyFile);
     if Printer.Printing then
       Printer.EndDoc; { just in case }

     bDeselectMSAWFaxAsPrinter;  { also deselects WinFax Pro }
  end;
  Screen.Cursor := crDefault;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
  0 : if not WinFaxAvailable then RadioGroup1.ItemIndex := -1;
  1 : if not MSAWFaxAvailable then RadioGroup1.ItemIndex := -1;
  end;
  if RadioGroup1.ItemIndex < 0 then
    Button2.Enabled := false
  else
    Button2.Enabled := true;
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  if not bWinFaxInstalled then begin
     MessageDlg('WinFax Pro has not been installed', mtError, [mbOk], 0);
     Exit;
  end;

  OpenDialog1.FileName := Edit1.Text;
  OpenDialog1.Filter := 'Coverpage files (*.CVP)|*.CVP';
  OpenDialog1.FilterIndex := 1;
  OpenDialog1.InitialDir := sGetWinFaxDir+'cover';
  if OpenDialog1.Execute then
     Edit1.Text := OpenDialog1.FileName;
end;

procedure TForm1.Edit2Click(Sender: TObject);
begin
  if not bWinFaxInstalled then begin
     MessageDlg('WinFax Pro has not been installed', mtError, [mbOk], 0);
     Exit;
  end;

  OpenDialog1.FileName := Edit2.Text;
  OpenDialog1.Filter := 'Attachments (*.FXS)|*.FXS|' +
                        'Text files (*.TXT)|*.TXT';
  OpenDialog1.FilterIndex := 1;
  OpenDialog1.InitialDir := sGetWinFaxDir;
  if OpenDialog1.Execute then
     Edit2.Text := OpenDialog1.FileName;
end;

procedure TForm1.Edit5Click(Sender: TObject);
begin
  SpinButton1.FocusControl := Edit5;
end;

procedure TForm1.Edit6Click(Sender: TObject);
begin
  SpinButton1.FocusControl := Edit6;
end;

procedure TForm1.SpinButton1UpClick(Sender: TObject);
begin
  if (SpinButton1.FocusControl=Edit6) then
    Edit6.Text := PadLwith(IntToStr(StrToInt(Edit6.Text)+1),2,'0');
  if (SpinButton1.FocusControl=Edit5) then
    Edit5.Text := PadLwith(IntToStr(StrToInt(Edit5.Text)+1),2,'0');
  if StrToInt(Edit5.Text) > 23 then Edit5.Text := '00';
  if StrToInt(Edit6.Text) > 59 then Edit6.Text := '00';
end;

procedure TForm1.SpinButton1DownClick(Sender: TObject);
begin
  if (SpinButton1.FocusControl=Edit6) then
    Edit6.Text := IntToStr(StrToInt(Edit6.Text)-1);
  if (SpinButton1.FocusControl=Edit5) then
    Edit5.Text := IntToStr(StrToInt(Edit5.Text)-1);
  if StrToInt(Edit5.Text) < 0 then Edit5.Text := '23';
  if StrToInt(Edit6.Text) < 0 then Edit6.Text := '59';
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Label13.Caption := FormatDateTime('hh:mm:ss', Now);
  if WinFaxLinkOK then
    Label8.Caption := 'WinFax Status is ' + sGetWinFaxStatus;
end;

end.
